//=============================================================================
//
// ͏ [input.h]
// Author : KENSUKE WATANABE
//
//=============================================================================
#pragma once
#ifndef _INPUTMOUSE_H_
#define _INPUTMOUSE_H_

#include "input.h"

//-----------------------------------------------------------------------------
// }EX
//-----------------------------------------------------------------------------
class CInputMouse : public CInput
{
public:
	typedef enum			// }EX{^zu
	{
		MOUSE_RIGHT = 0,	// E
		MOUSE_LEFT = 1		// 
	}MOUSE_BUTTON;

	CInputMouse() :m_pDIDevice(nullptr) {};
	~CInputMouse() {};

	HRESULT Init(HINSTANCE hInst, HWND hWnd);
	void Uninit(void);
	void Update(HWND hWnd);

	int GetPosX(void) { return (int)m_Pos.x; }
	int GetPosY(void) { return (int)m_Pos.y; }
	bool GetPress(int nKey) { return (m_aState[nKey] & 0x80) ? true : false; }
	bool GetTrigger(int nKey) { return (m_aStateTrigger[nKey] & 0x80) ? true : false; }
	bool GetRelease(int nKey) { return (m_aStateRelease[nKey] & 0x80) ? true : false; }
	bool GetRepeat(int nKey) { return (m_aStateRepeat[nKey] & 0x80) ? true : false; }
	void FlushTrigger(int nKey) { m_aStateTrigger[nKey] = 0; }

private:
	BYTE			m_aState[NUM_MOUSE_MAX];			//
	BYTE			m_aStateTrigger[NUM_MOUSE_MAX];		//
	BYTE			m_aStateRelease[NUM_MOUSE_MAX];		//
	BYTE			m_aStateRepeat[NUM_MOUSE_MAX];		//
	BYTE			m_aStateRepeatCnt[NUM_MOUSE_MAX];	//
	POINT			m_Pos;								// }EX̍W
	POINT			m_PosOld;							// }EX1fO̍W
	D3DXVECTOR2		m_PointMove;						// }EẌړ

	LPDIRECTINPUTDEVICE8 m_pDIDevice;		// DeviceIuWFNg(͂ɕKv)
};

#endif